/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.banktags.tabs;

import java.util.Arrays;
import lombok.NonNull;

public class Layout {
    private final String tag;
    private int[] layout;

    public Layout(String tag) {
        this.tag = tag;
        this.layout = new int[0];
    }

    public Layout(String tag, @NonNull int[] layout) {
        if (layout == null) {
            throw new NullPointerException("layout is marked non-null but is null");
        }
        this.tag = tag;
        this.layout = layout;
    }

    public Layout(Layout other) {
        this.tag = other.tag;
        this.layout = (int[])other.layout.clone();
    }

    public int[] getLayout() {
        return (int[])this.layout.clone();
    }

    public int getItemAtPos(int pos) {
        if (pos < 0 || pos >= this.layout.length) {
            return -1;
        }
        return this.layout[pos];
    }

    public void setItemAtPos(int itemId, int pos) {
        if (pos < 0) {
            return;
        }
        if (this.layout == null) {
            this.layout = new int[pos + 1];
            Arrays.fill(this.layout, -1);
        } else if (pos >= this.layout.length) {
            int[] n2 = Arrays.copyOf(this.layout, pos + 1);
            Arrays.fill(n2, this.layout.length, n2.length, -1);
            this.layout = n2;
        }
        this.layout[pos] = itemId;
    }

    public void addItem(int itemId) {
        this.addItemAfter(itemId, 0);
    }

    public void addItemAfter(int itemId, int pos) {
        for (int i2 = pos; i2 < this.layout.length; ++i2) {
            if (this.layout[i2] != -1) continue;
            this.layout[i2] = itemId;
            return;
        }
        this.resize(Math.max(pos + 1, this.layout.length + 1));
        this.layout[i2] = itemId;
    }

    public void removeItem(int itemId) {
        for (int i2 = 0; i2 < this.layout.length; ++i2) {
            if (this.layout[i2] != itemId) continue;
            this.layout[i2] = -1;
        }
    }

    public void removeItemAtPos(int pos) {
        if (pos < 0 || pos >= this.layout.length) {
            return;
        }
        this.layout[pos] = -1;
    }

    void swap(int sidx, int tidx) {
        int sid = this.layout[sidx];
        this.layout[sidx] = this.layout[tidx];
        this.layout[tidx] = sid;
    }

    void insert(int sidx, int tidx) {
        int sid = this.layout[sidx];
        if (sidx < tidx) {
            int i2;
            for (i2 = tidx; i2 > sidx && this.layout[i2] > -1; --i2) {
            }
            this.layout[sidx] = -1;
            System.arraycopy(this.layout, i2 + 1, this.layout, i2, tidx - i2);
            this.layout[tidx] = sid;
        } else if (sidx > tidx) {
            int i3;
            for (i3 = tidx; i3 < sidx && this.layout[i3] > -1; ++i3) {
            }
            this.layout[sidx] = -1;
            System.arraycopy(this.layout, tidx, this.layout, tidx + 1, i3 - tidx);
            this.layout[tidx] = sid;
        }
    }

    public int count(int itemId) {
        int c2 = 0;
        for (int value : this.layout) {
            if (value != itemId) continue;
            ++c2;
        }
        return c2;
    }

    public int size() {
        return this.layout.length;
    }

    public void resize(int size) {
        int[] n2 = Arrays.copyOf(this.layout, size);
        if (size > this.layout.length) {
            Arrays.fill(n2, this.layout.length, size, -1);
        }
        this.layout = n2;
    }

    public String getTag() {
        return this.tag;
    }
}

